/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import bootswithdefer.JDCBPool.JDCConnectionDriver;
import com.nijikokun.bukkit.Permissions.Permissions;
import de.diddiz.LogBlock.AreaBlockSearch;
import de.diddiz.LogBlock.AreaStats;
import de.diddiz.LogBlock.BlockStats;
import de.diddiz.LogBlock.ClearLog;
import de.diddiz.LogBlock.Config;
import de.diddiz.LogBlock.PlayerAreaStats;
import de.diddiz.LogBlock.Rollback;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockInteractEvent;
import org.bukkit.event.block.BlockListener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRightClickEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityListener;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerItemEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class LogBlock
extends JavaPlugin {
    static Logger log;
    private Consumer consumer = null;
    private LinkedBlockingQueue<BlockRow> bqueue = new LinkedBlockingQueue();
    private ArrayList<Session> sessions = new ArrayList();

    public void onEnable() {
        log = this.getServer().getLogger();
        try {
            Config.Load(this.getConfiguration());
            if (Config.usePermissions) {
                if (this.getServer().getPluginManager().getPlugin("Permissions") != null) {
                    log.info("[LogBlock] Permissions enabled");
                } else {
                    Config.usePermissions = true;
                    log.warning("[LogBlock] Permissions plugin not found. Using default permissions.");
                }
            }
            new JDCConnectionDriver(Config.dbDriver, Config.dbUrl, Config.dbUsername, Config.dbPassword);
            Connection conn = this.getConnection();
            conn.close();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "[LogBlock] Exception while enabling", ex);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (Config.worldNames == null || Config.worldTables == null || Config.worldNames.size() == 0 || Config.worldNames.size() != Config.worldTables.size()) {
            log.log(Level.SEVERE, "[LogBlock] worldNames or worldTables not set porperly");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (!this.checkTables()) {
            log.log(Level.SEVERE, "[LogBlock] Errors while checking tables. They may not exist.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (Config.keepLogDays >= 0) {
            new Thread(new ClearLog(this.getConnection())).start();
        }
        LBBlockListener lbBlockListener = new LBBlockListener();
        LBPlayerListener lbPlayerListener = new LBPlayerListener();
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvent(Event.Type.PLAYER_ITEM, (Listener)lbPlayerListener, Event.Priority.Monitor, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_JOIN, (Listener)lbPlayerListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_RIGHTCLICKED, (Listener)lbBlockListener, Event.Priority.Monitor, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_PLACED, (Listener)lbBlockListener, Event.Priority.Monitor, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_BREAK, (Listener)lbBlockListener, Event.Priority.Monitor, (Plugin)this);
        pm.registerEvent(Event.Type.SIGN_CHANGE, (Listener)lbBlockListener, Event.Priority.Monitor, (Plugin)this);
        if (Config.logFire) {
            pm.registerEvent(Event.Type.BLOCK_BURN, (Listener)lbBlockListener, Event.Priority.Monitor, (Plugin)this);
        }
        if (Config.logExplosions) {
            pm.registerEvent(Event.Type.ENTITY_EXPLODE, (Listener)new LBEntityListener(), Event.Priority.Monitor, (Plugin)this);
        }
        if (Config.logChestAccess) {
            pm.registerEvent(Event.Type.BLOCK_INTERACT, (Listener)lbBlockListener, Event.Priority.Monitor, (Plugin)this);
        }
        if (Config.logLeavesDecay) {
            pm.registerEvent(Event.Type.LEAVES_DECAY, (Listener)lbBlockListener, Event.Priority.Monitor, (Plugin)this);
        }
        this.consumer = new Consumer();
        new Thread(this.consumer).start();
        log.info("Logblock v" + this.getDescription().getVersion() + " enabled.");
    }

    public void onDisable() {
        if (this.consumer != null) {
            log.info("[LogBlock] Stopping consumer");
            this.consumer.stop();
        }
        log.info("LogBlock disabled.");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("lb")) {
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("You aren't a player");
            return true;
        }
        Player player = (Player)sender;
        Connection conn = this.getConnection();
        String table = this.getTable(player);
        if (conn == null) {
            player.sendMessage(ChatColor.RED + "Can't create SQL connection.");
            return true;
        }
        if (table == null) {
            player.sendMessage(ChatColor.RED + "This world isn't logged");
            return true;
        }
        if (args.length == 0) {
            player.sendMessage(ChatColor.RED + "No argument. Type /lb help for help");
        } else if (args[0].equalsIgnoreCase("area")) {
            if (this.CheckPermission(player, "logblock.area")) {
                int radius = Config.defaultDist;
                if (args.length == 2 && this.isInt(args[1])) {
                    radius = Integer.parseInt(args[1]);
                }
                new Thread(new AreaStats(conn, player, radius, table)).start();
            } else {
                player.sendMessage(ChatColor.RED + "You aren't allowed to do this");
            }
        } else if (args[0].equalsIgnoreCase("world")) {
            if (this.CheckPermission(player, "logblock.area")) {
                new Thread(new AreaStats(conn, player, Short.MAX_VALUE, table)).start();
            } else {
                player.sendMessage(ChatColor.RED + "You aren't allowed to do this");
            }
        } else if (args[0].equalsIgnoreCase("player")) {
            if (this.CheckPermission(player, "logblock.area")) {
                if (args.length == 2 || args.length == 3) {
                    int radius = Config.defaultDist;
                    if (args.length == 3 && this.isInt(args[2])) {
                        radius = Integer.parseInt(args[2]);
                    }
                    new Thread(new PlayerAreaStats(conn, player, args[1], radius, table)).start();
                } else {
                    player.sendMessage(ChatColor.RED + "Usage: /lb player [name] <radius>");
                }
            } else {
                player.sendMessage(ChatColor.RED + "You aren't allowed to do this");
            }
        } else if (args[0].equalsIgnoreCase("block")) {
            if (this.CheckPermission(player, "logblock.area")) {
                if (args.length == 2 || args.length == 3) {
                    Material mat = Material.matchMaterial((String)args[1]);
                    int radius = Config.defaultDist;
                    if (args.length == 3 && this.isInt(args[2])) {
                        radius = Integer.parseInt(args[2]);
                    }
                    if (mat != null) {
                        new Thread(new AreaBlockSearch(conn, player, mat.getId(), radius, table)).start();
                    } else {
                        player.sendMessage(ChatColor.RED + "Can't find any item like '" + args[1] + "'");
                    }
                } else {
                    player.sendMessage(ChatColor.RED + "Usage: /lb block [type] <radius>");
                }
            } else {
                player.sendMessage(ChatColor.RED + "You aren't allowed to do this");
            }
        } else if (args[0].equalsIgnoreCase("setpos")) {
            if (this.CheckPermission(player, "logblock.rollback")) {
                Session session = this.getSession(player);
                Location loc = player.getTargetBlock(null, Integer.MAX_VALUE).getLocation();
                if (args.length == 1) {
                    if (!session.isloc1Set()) {
                        session.loc1 = loc;
                        player.sendMessage(ChatColor.GREEN + "Pos 1 set.");
                    } else if (!session.isloc2Set()) {
                        session.loc2 = loc;
                        player.sendMessage(ChatColor.GREEN + "Pos 2 set.");
                    } else {
                        session.loc1 = loc;
                        session.loc2 = null;
                        player.sendMessage(ChatColor.GREEN + "Positions cleared.");
                        player.sendMessage(ChatColor.GREEN + "Pos 1 set.");
                    }
                } else if (args.length == 2) {
                    if (args[1].equalsIgnoreCase("1")) {
                        session.loc1 = loc;
                        player.sendMessage(ChatColor.GREEN + "Pos 1 set.");
                    } else if (args[1].equalsIgnoreCase("2")) {
                        session.loc2 = loc;
                        player.sendMessage(ChatColor.GREEN + "Pos 2 set.");
                    } else {
                        player.sendMessage(ChatColor.RED + "Wrong parameter. Try to use either 1 or 2");
                    }
                } else {
                    player.sendMessage(ChatColor.RED + "Usage: /lb setpos <1|2>");
                }
            } else {
                player.sendMessage(ChatColor.RED + "You aren't allowed to do this");
            }
        } else if (args[0].equalsIgnoreCase("rollback")) {
            if (this.CheckPermission(player, "logblock.rollback")) {
                if (args.length >= 2) {
                    int minutes = Config.defaultTime;
                    if (args[1].equalsIgnoreCase("player")) {
                        if (args.length == 3 || args.length == 5) {
                            if (args.length == 5) {
                                minutes = LogBlock.parseTimeSpec(args[3], args[4]);
                            }
                            player.sendMessage(ChatColor.GREEN + "Rolling back " + args[2] + " by " + minutes + " minutes.");
                            new Thread(new Rollback(player, conn, args[2], minutes, table)).start();
                        } else {
                            player.sendMessage(ChatColor.RED + "Usage: /lb rollback player [name] <time> <minutes|hours|days>");
                        }
                    } else if (args[1].equalsIgnoreCase("area")) {
                        if (args.length == 3 || args.length == 5) {
                            if (args.length == 5) {
                                minutes = LogBlock.parseTimeSpec(args[3], args[4]);
                            }
                            if (this.isInt(args[2])) {
                                player.sendMessage(ChatColor.GREEN + "Rolling back area within " + args[2] + " blocks of you by " + minutes + " minutes.");
                                new Thread(new Rollback(player, conn, Integer.parseInt(args[2]), minutes, table)).start();
                            } else {
                                player.sendMessage(ChatColor.RED + "Can't parse to an int: " + args[2]);
                            }
                        } else {
                            player.sendMessage(ChatColor.RED + "Usage /lb rollback area [radius] <time> <minutes|hours|days>");
                        }
                    } else if (args[1].equalsIgnoreCase("playerarea")) {
                        if (args.length == 4 || args.length == 6) {
                            if (args.length == 6) {
                                minutes = LogBlock.parseTimeSpec(args[4], args[5]);
                            }
                            if (this.isInt(args[3])) {
                                player.sendMessage(ChatColor.GREEN + "Rolling back " + args[2] + " within " + args[3] + " blocks by " + minutes + " minutes.");
                                new Thread(new Rollback(player, conn, args[2], Integer.parseInt(args[3]), minutes, table)).start();
                            } else {
                                player.sendMessage(ChatColor.RED + "Can't parse to an int: " + args[3]);
                            }
                        } else {
                            player.sendMessage(ChatColor.RED + "Usage: /lb rollback playerarea [player] [radius] <time> <minutes|hours|days>");
                        }
                    } else if (args[1].equalsIgnoreCase("cuboid")) {
                        if (args.length == 2 || args.length == 4) {
                            Session session;
                            if (args.length == 4) {
                                minutes = LogBlock.parseTimeSpec(args[2], args[3]);
                            }
                            if ((session = this.getSession(player)).isloc1Set() && session.isloc2Set()) {
                                player.sendMessage(ChatColor.GREEN + "Rolling back selected cuboid by " + minutes + " minutes.");
                                new Thread(new Rollback(player, conn, session.loc1, session.loc2, minutes, table)).start();
                            } else {
                                player.sendMessage(ChatColor.RED + "No cuboid selected. Use /lb setpos");
                            }
                        } else {
                            player.sendMessage(ChatColor.RED + "Usage: /lb rollback cuboid <time> <minutes|hours|days>");
                        }
                    } else {
                        player.sendMessage(ChatColor.RED + "Wrong rollback mode");
                    }
                } else {
                    player.sendMessage(ChatColor.RED + "Usage: ");
                    player.sendMessage(ChatColor.RED + "/lb rollback player [name] <time> <minutes|hours|days>");
                    player.sendMessage(ChatColor.RED + "/lb rollback area [radius] <time> <minutes|hours|days>");
                    player.sendMessage(ChatColor.RED + "/lb rollback playerarea [name] [radius] <time> <minutes|hours|days>");
                    player.sendMessage(ChatColor.RED + "/lb rollback cuboid <time> <minutes|hours|days>");
                }
            } else {
                player.sendMessage(ChatColor.RED + "You aren't allowed to do this");
            }
        } else if (args[0].equalsIgnoreCase("me")) {
            if (this.CheckPermission(player, "logblock.me")) {
                new Thread(new PlayerAreaStats(conn, player, player.getName(), Short.MAX_VALUE, table)).start();
            } else {
                player.sendMessage(ChatColor.RED + "You aren't allowed to do this");
            }
        } else if (args[0].equalsIgnoreCase("help")) {
            player.sendMessage("\u00a7dLogBlock Commands:");
            player.sendMessage("\u00a7d/lb area <radius>");
            player.sendMessage("\u00a7d/lb world");
            player.sendMessage("\u00a7d/lb player [name] <radius>");
            player.sendMessage("\u00a7d/lb block [type] <radius>");
            player.sendMessage("\u00a7d/lb setpos <1|2>");
            player.sendMessage("\u00a7d/lb rollback [rollback mode]");
        } else {
            player.sendMessage(ChatColor.RED + "Wrong argument. Type /lb help for help");
        }
        return true;
    }

    private Connection getConnection() {
        try {
            return DriverManager.getConnection("jdbc:jdc:jdcpool");
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, "[LogBlock] SQL exception", ex);
            return null;
        }
    }

    private boolean checkTables() {
        Connection conn = this.getConnection();
        Statement state = null;
        if (conn == null) {
            return false;
        }
        try {
            DatabaseMetaData dbm = conn.getMetaData();
            state = conn.createStatement();
            if (!dbm.getTables(null, null, "lb-players", null).next()) {
                log.log(Level.INFO, "[LogBlock] Crating table players.");
                state.execute("CREATE TABLE `lb-players` (`playerid` SMALLINT UNSIGNED NOT NULL AUTO_INCREMENT, `playername` varchar(32) NOT NULL DEFAULT '-', PRIMARY KEY (`playerid`), UNIQUE (`playername`))");
                if (!dbm.getTables(null, null, "lb-players", null).next()) {
                    return false;
                }
            }
            state.execute("INSERT IGNORE INTO `lb-players` (`playername`) VALUES ('" + Config.logTNTExplosionsAs + "'), ('" + Config.logCreeperExplosionsAs + "'), ('" + Config.logFireAs + "'), ('" + Config.logLeavesDecayAs + "')");
            int i = 0;
            while (i < Config.worldNames.size()) {
                String table = Config.worldTables.get(i);
                if (!dbm.getTables(null, null, table, null).next()) {
                    log.log(Level.INFO, "[LogBlock] Crating table " + table + ".");
                    state.execute("CREATE TABLE `" + table + "` (`id` INT NOT NULL AUTO_INCREMENT, `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00', `playerid` SMALLINT UNSIGNED NOT NULL DEFAULT '0', `replaced` TINYINT UNSIGNED NOT NULL DEFAULT '0', `type` TINYINT UNSIGNED NOT NULL DEFAULT '0', `data` TINYINT UNSIGNED NOT NULL DEFAULT '0', `x` SMALLINT NOT NULL DEFAULT '0', `y` TINYINT UNSIGNED NOT NULL DEFAULT '0',`z` SMALLINT NOT NULL DEFAULT '0', PRIMARY KEY (`id`), KEY `coords` (`y`,`x`,`z`), KEY `type` (`type`), KEY `data` (`data`), KEY `replaced` (`replaced`));");
                    if (!dbm.getTables(null, null, table, null).next()) {
                        return false;
                    }
                }
                if (!dbm.getTables(null, null, String.valueOf(table) + "-sign", null).next()) {
                    log.log(Level.INFO, "[LogBlock] Crating table " + table + "-sign.");
                    state.execute("CREATE TABLE `" + table + "-sign` (`id` INT NOT NULL, `signtext` TEXT, PRIMARY KEY (`id`));");
                    if (!dbm.getTables(null, null, String.valueOf(table) + "-sign", null).next()) {
                        return false;
                    }
                }
                if (!dbm.getTables(null, null, String.valueOf(table) + "-chest", null).next()) {
                    log.log(Level.INFO, "[LogBlock] Crating table " + table + "-chest.");
                    state.execute("CREATE TABLE `" + table + "-chest` (`id` INT NOT NULL, `intype` SMALLINT UNSIGNED NOT NULL DEFAULT '0', `inamount` TINYINT UNSIGNED NOT NULL DEFAULT '0', `outtype` SMALLINT UNSIGNED NOT NULL DEFAULT '0', `outamount` TINYINT UNSIGNED NOT NULL DEFAULT '0', PRIMARY KEY (`id`));");
                    if (!dbm.getTables(null, null, String.valueOf(table) + "-chest", null).next()) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, "[LogBlock] SQL exception while checking tables", ex);
        }
        finally {
            try {
                if (state != null) {
                    state.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                log.log(Level.SEVERE, "[LogBlock] SQL exception on close", ex);
            }
        }
        return false;
    }

    private String getTable(Player player) {
        return this.getTable(player.getWorld().getName());
    }

    private String getTable(Block block) {
        return this.getTable(block.getWorld().getName());
    }

    private String getTable(String worldName) {
        int idx = Config.worldNames.indexOf(worldName);
        if (idx == -1) {
            return null;
        }
        return Config.worldTables.get(idx);
    }

    private void queueBlock(Player player, Block block, int typeAfter) {
        this.queueBlock(player.getName(), block, 0, typeAfter, (byte)0, null, null);
    }

    private void queueBlock(String playerName, Block block, int typeBefore, int typeAfter, byte data) {
        this.queueBlock(playerName, block, typeBefore, typeAfter, data, null, null);
    }

    private void queueBlock(Player player, Block block, short inType, byte inAmount, short outType, byte outAmount) {
        this.queueBlock(player.getName(), block, 54, 54, (byte)0, null, new ChestAccess(inType, inAmount, outType, outAmount));
    }

    private void queueBlock(String playerName, Block block, int typeBefore, int typeAfter, byte data, String signtext, ChestAccess ca) {
        if (block == null || typeBefore < 0 || typeAfter < 0) {
            return;
        }
        String table = this.getTable(block);
        if (table == null) {
            return;
        }
        if (playerName.length() > 32) {
            playerName = playerName.substring(0, 31);
        }
        BlockRow row = new BlockRow(table, playerName, typeBefore, typeAfter, data, block.getX(), block.getY(), block.getZ());
        if (signtext != null) {
            row.signtext = signtext;
        }
        if (ca != null) {
            row.ca = ca;
        }
        if (!this.bqueue.offer(row)) {
            log.info("[LogBlock] Failed to queue block for " + playerName);
        }
    }

    private boolean CheckPermission(Player player, String permission) {
        if (Config.usePermissions) {
            return Permissions.Security.permission(player, permission);
        }
        if (permission.equals("logblock.lookup")) {
            return true;
        }
        if (permission.equals("logblock.area")) {
            return player.isOp();
        }
        if (permission.equals("logblock.rollback")) {
            return player.isOp();
        }
        return false;
    }

    static int parseTimeSpec(String timespec) {
        String[] split = timespec.split(" ");
        if (split.length != 2) {
            return 0;
        }
        return LogBlock.parseTimeSpec(split[0], split[1]);
    }

    static int parseTimeSpec(String time, String unit) {
        int min;
        try {
            min = Integer.parseInt(time);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
        if (unit.startsWith("hour")) {
            min *= 60;
        } else if (unit.startsWith("day")) {
            min *= 1440;
        }
        return min;
    }

    private Session getSession(Player player) {
        int idx = this.sessions.indexOf(new Session(player));
        if (idx != -1) {
            return this.sessions.get(idx);
        }
        this.sessions.add(new Session(player));
        return this.getSession(player);
    }

    private boolean isInt(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private class BlockRow {
        public String table;
        public String name;
        public int replaced;
        public int type;
        public byte data;
        public int x;
        public int y;
        public int z;
        public String signtext;
        public ChestAccess ca;

        BlockRow(String table, String name, int replaced, int type, byte data, int x, int y, int z) {
            this.table = table;
            this.name = name;
            this.replaced = replaced;
            this.type = type;
            this.data = data;
            this.x = x;
            this.y = y;
            this.z = z;
            this.signtext = null;
            this.ca = null;
        }
    }

    private class ChestAccess {
        public short inType;
        public short outType;
        public byte inAmount;
        public byte outAmount;

        ChestAccess(short inType, byte inAmount, short outType, byte outAmount) {
            this.inType = inType;
            this.inAmount = inAmount;
            this.outType = outType;
            this.outAmount = outAmount;
        }
    }

    private class Consumer
    implements Runnable {
        private boolean stop = false;

        Consumer() {
        }

        public void stop() {
            this.stop = true;
        }

        @Override
        public void run() {
            Statement ps = null;
            Connection conn = null;
            while (!this.stop) {
                long start = System.currentTimeMillis() / 1000L;
                int count = 0;
                if (LogBlock.this.bqueue.size() > 100) {
                    log.info("[LogBlock] Queue overloaded. Size: " + LogBlock.this.bqueue.size());
                }
                try {
                    conn = LogBlock.this.getConnection();
                    conn.setAutoCommit(false);
                    while (count < 100 && start + (long)Config.delay > System.currentTimeMillis() / 1000L) {
                        int key;
                        ResultSet keys;
                        BlockRow b = (BlockRow)LogBlock.this.bqueue.poll(1L, TimeUnit.SECONDS);
                        if (b == null) continue;
                        ps = conn.prepareStatement("INSERT INTO `" + b.table + "` (`date`, `playerid`, `replaced`, `type`, `data`, `x`, `y`, `z`) SELECT now(), `playerid`, ?, ?, ?, ?, ? , ? FROM `lb-players` WHERE `playername` = ?", 1);
                        ps.setInt(1, b.replaced);
                        ps.setInt(2, b.type);
                        ps.setByte(3, b.data);
                        ps.setInt(4, b.x);
                        ps.setInt(5, b.y);
                        ps.setInt(6, b.z);
                        ps.setString(7, b.name);
                        ps.executeUpdate();
                        if (b.signtext != null) {
                            keys = ps.getGeneratedKeys();
                            keys.next();
                            key = keys.getInt(1);
                            ps = conn.prepareStatement("INSERT INTO `" + b.table + "-sign` (`id`, `signtext`) values (?,?)");
                            ps.setInt(1, key);
                            ps.setString(2, b.signtext);
                            ps.executeUpdate();
                        } else if (b.ca != null) {
                            keys = ps.getGeneratedKeys();
                            keys.next();
                            key = keys.getInt(1);
                            ps = conn.prepareStatement("INSERT INTO `" + b.table + "-chest` (`id`, `intype`, `inamount`, `outtype`, `outamount`) values (?,?,?,?,?)");
                            ps.setInt(1, key);
                            ps.setShort(2, b.ca.inType);
                            ps.setByte(3, b.ca.inAmount);
                            ps.setShort(4, b.ca.outType);
                            ps.setByte(5, b.ca.outAmount);
                            ps.executeUpdate();
                        }
                        ++count;
                    }
                    conn.commit();
                }
                catch (InterruptedException ex) {
                    log.log(Level.SEVERE, "[LogBlock] Interrupted exception", ex);
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                        if (conn == null) continue;
                        conn.close();
                    }
                    catch (SQLException ex2) {
                        log.log(Level.SEVERE, "[LogBlock] SQL exception on close", ex2);
                    }
                    continue;
                }
                catch (SQLException ex) {
                    try {
                        log.log(Level.SEVERE, "[LogBlock] SQL exception", ex);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        try {
                            if (ps != null) {
                                ps.close();
                            }
                            if (conn != null) {
                                conn.close();
                            }
                        }
                        catch (SQLException ex3) {
                            log.log(Level.SEVERE, "[LogBlock] SQL exception on close", ex3);
                        }
                    }
                }
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    if (conn == null) continue;
                    conn.close();
                }
                catch (SQLException ex) {
                    log.log(Level.SEVERE, "[LogBlock] SQL exception on close", ex);
                }
            }
        }
    }

    private class LBBlockListener
    extends BlockListener {
        private LBBlockListener() {
        }

        public void onBlockRightClick(BlockRightClickEvent event) {
            if (event.getItemInHand().getTypeId() == Config.toolID && LogBlock.this.CheckPermission(event.getPlayer(), "logblock.lookup")) {
                new Thread(new BlockStats(LogBlock.this.getConnection(), event.getPlayer(), event.getBlock(), LogBlock.this.getTable(event.getBlock()))).start();
            }
        }

        public void onBlockPlace(BlockPlaceEvent event) {
            if (!event.isCancelled()) {
                if (event.getItemInHand().getTypeId() == Config.toolblockID && LogBlock.this.CheckPermission(event.getPlayer(), "logblock.lookup")) {
                    new Thread(new BlockStats(LogBlock.this.getConnection(), event.getPlayer(), event.getBlock(), LogBlock.this.getTable(event.getBlock()))).start();
                    if (Config.toolblockRemove) {
                        event.setCancelled(true);
                    }
                } else {
                    LogBlock.this.queueBlock(event.getPlayer().getName(), event.getBlockPlaced(), event.getBlockReplacedState().getTypeId(), event.getBlockPlaced().getTypeId(), event.getBlockPlaced().getData());
                }
            }
        }

        public void onBlockBreak(BlockBreakEvent event) {
            if (!event.isCancelled()) {
                LogBlock.this.queueBlock(event.getPlayer().getName(), event.getBlock(), event.getBlock().getTypeId(), 0, event.getBlock().getData());
            }
        }

        public void onSignChange(SignChangeEvent event) {
            if (!event.isCancelled()) {
                if (Config.logSignTexts) {
                    LogBlock.this.queueBlock(event.getPlayer().getName(), event.getBlock(), 0, event.getBlock().getTypeId(), event.getBlock().getData(), "sign [" + event.getLine(0) + "] [" + event.getLine(1) + "] [" + event.getLine(2) + "] [" + event.getLine(3) + "]", null);
                } else {
                    LogBlock.this.queueBlock(event.getPlayer().getName(), event.getBlock(), 0, event.getBlock().getTypeId(), event.getBlock().getData());
                }
            }
        }

        public void onBlockBurn(BlockBurnEvent event) {
            if (!event.isCancelled()) {
                LogBlock.this.queueBlock(Config.logFireAs, event.getBlock(), event.getBlock().getTypeId(), 0, event.getBlock().getData());
            }
        }

        public void onBlockInteract(BlockInteractEvent event) {
            if (!event.isCancelled() && event.isPlayer() && event.getBlock().getType() == Material.CHEST) {
                if (((Player)event.getEntity()).getItemInHand().getTypeId() == Config.toolID) {
                    event.setCancelled(true);
                } else {
                    LogBlock.this.queueBlock((Player)event.getEntity(), event.getBlock(), (short)0, (byte)0, (short)0, (byte)0);
                }
            }
        }

        public void onLeavesDecay(LeavesDecayEvent event) {
            if (!event.isCancelled()) {
                LogBlock.this.queueBlock(Config.logLeavesDecayAs, event.getBlock(), event.getBlock().getTypeId(), 0, event.getBlock().getData());
            }
        }
    }

    private class LBEntityListener
    extends EntityListener {
        private LBEntityListener() {
        }

        public void onEntityExplode(EntityExplodeEvent event) {
            if (!event.isCancelled()) {
                String name = event.getEntity() == null ? Config.logTNTExplosionsAs : Config.logCreeperExplosionsAs;
                for (Block block : event.blockList()) {
                    LogBlock.this.queueBlock(name, block, block.getTypeId(), 0, block.getData());
                }
            }
        }
    }

    private class LBPlayerListener
    extends PlayerListener {
        private LBPlayerListener() {
        }

        public void onPlayerItem(PlayerItemEvent event) {
            if (!event.isCancelled() && event.getBlockClicked() != null) {
                switch (event.getMaterial()) {
                    case BUCKET: {
                        LogBlock.this.queueBlock(event.getPlayer().getName(), event.getBlockClicked(), event.getBlockClicked().getTypeId(), 0, event.getBlockClicked().getData());
                        break;
                    }
                    case WATER_BUCKET: {
                        LogBlock.this.queueBlock(event.getPlayer(), event.getBlockClicked().getFace(event.getBlockFace()), Material.STATIONARY_WATER.getId());
                        break;
                    }
                    case LAVA_BUCKET: {
                        LogBlock.this.queueBlock(event.getPlayer(), event.getBlockClicked().getFace(event.getBlockFace()), Material.STATIONARY_LAVA.getId());
                        break;
                    }
                    case FLINT_AND_STEEL: {
                        LogBlock.this.queueBlock(event.getPlayer(), event.getBlockClicked().getFace(event.getBlockFace()), Material.FIRE.getId());
                        break;
                    }
                    case SEEDS: {
                        LogBlock.this.queueBlock(event.getPlayer(), event.getBlockClicked().getFace(event.getBlockFace()), Material.CROPS.getId());
                        break;
                    }
                    case WOOD_HOE: 
                    case STONE_HOE: 
                    case IRON_HOE: 
                    case DIAMOND_HOE: 
                    case GOLD_HOE: {
                        LogBlock.this.queueBlock(event.getPlayer().getName(), event.getBlockClicked(), event.getBlockClicked().getTypeId(), Material.SOIL.getId(), (byte)0);
                    }
                }
            }
        }

        public void onPlayerJoin(PlayerEvent event) {
            Connection conn = LogBlock.this.getConnection();
            Statement state = null;
            if (conn == null) {
                return;
            }
            try {
                try {
                    state = conn.createStatement();
                    state.execute("INSERT IGNORE INTO `lb-players` (`playername`) VALUES ('" + event.getPlayer().getName() + "');");
                }
                catch (SQLException ex) {
                    log.log(Level.SEVERE, "[LogBlock] SQL exception", ex);
                    try {
                        if (state != null) {
                            state.close();
                        }
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException ex2) {
                        log.log(Level.SEVERE, "[LogBlock] SQL exception on close", ex2);
                    }
                }
            }
            finally {
                try {
                    if (state != null) {
                        state.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException ex) {
                    log.log(Level.SEVERE, "[LogBlock] SQL exception on close", ex);
                }
            }
        }
    }

    private class Session {
        public String user;
        public Location loc1 = null;
        public Location loc2 = null;

        public Session(Player player) {
            this.user = player.getName();
        }

        public boolean isloc1Set() {
            return this.loc1 != null;
        }

        public boolean isloc2Set() {
            return this.loc2 != null;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.user.equalsIgnoreCase(((Session)obj).user);
        }
    }
}

